---
title: Ampere's theorem : application
published: false
visible: false
---



Théorème d'Ampère : application

### Que dit le théorème d'Ampère ?



 ### Quand l'utiliser et quel intérêt ?
 
 Le théorème d'Ampère permet un **calcul simple de $`\overrightarrow{B}`$** créé dans tout l'espace lorsque la *distribution spatiale de courant* est *hautement symétrique et invariante* : les distributions usuelles sont un courant constant dans :
- un fil infini.
- un solénoïde infini.
- une nappe de courant.
- une bobine toroïdale.

### Forme intégrale ou forme locale?

##### Intérêt et difficultés propres de la forme intégrale

* Calcul du champ magnétique **$`\overrightarrow{B}`$** à partir de la *distribution macroscopique des courants* ( I ou $`\overrightarrow{j}`$) :<br>
<br>$`\Longrightarrow`$ **toujours valable** :<br>
\- *même lors d'une modélisation 2D* des courants (le profil du courant selon une direction spatiale est négligée (souvent une épaisseur).<br>
\- *même lors d'une modélisation 1D* des courants (le profil du courant selon deux directions spatiales est négligée (souvent une section).<br>
<br>$`\Longrightarrow`$ permet d'établir les **relations de continuité de $`\overrightarrow{B}`$** *à la traversée d'une densité surfacique de courant* (2D) :<br>
\- discontinuité de la composante de $`\overrightarrow{B}`$ tangentielle à la surface.<br>
\- continuité de la composante de $`\overrightarrow{B}`$ perpendiculaire à la surface.

* Nécessite de **bien visualiser dans l'espace** la distribution de courant, pour choisir :<br>
\- le *bon contour* pour le calcul de la *circulation de $`\overrightarrow{B}`$*.<br>
\- la *bonne surface associée* pour le calcul *flux de $`\overrightarrow{j}`$*.

##### Intérêt et difficultés propres de la forme locale

* Reproduit le **profil de $`\overrightarrow{B}`$** dans l'espace par intégration à partir des *variations locale $`\dfrac{\partial B_i}{\partial \alpha_j}`$* en chaque point de l'espace, $`\displaystyle\overrightarrow{B}=\sum_{i=1}^3 B_i\,\overrightarrow{e_{\alpha i}}`$ étant exprimé dans un repère orthonormé $`(\overrightarrow{e_{\alpha1}}, \overrightarrow{e_{\alpha2}},\overrightarrow{e_{\alpha3}})`$<br>
<br> $`\Longrightarrow`$ chaque composante $`B_i`$ est **connue à une constante d'intégration près**.<br>
<br> $`\Longrightarrow`$ Il faut **lever l'indétermination des constantes** d'intégration par la connaissance de $`\overrightarrow{B}`$ en certains points grâce à des *considérations de symétries* (exemple $`\overrightarrow{B}=0`$) ou de *continuité de $`\overrightarrow{B}`$ dans une modélisation 3D* des courants.

* $`\Longrightarrow`$ l'utilisation de la **forme locale du théorème d'Ampère** sera *réservée à une modélisation 3D* des courants.



### Quelles sont les différentes étapes ?

##### Déterminer $`\overrightarrow{B}`$ en connaissant les courants.

Nous sommes en magnétostatique. Il faudrait préciser :<br>
Déterminer $`\overrightarrow{B}`$ statique en connaissant les courants constants.

* **ETAPE 1** : *Décrire mathématiquement la distribution spatiale de courants* à l'origine du champ magnétique $`\overrightarrow{B}`$, avec le vecteur densité volumique de courant $`\overrightarrow{j}`$ (modèle 3D).<br>
<br>*Parfois simplifier le modèle représentatif* :<br>
\- passage *3D vers 2D*, en négligeant de façon justifiée une dimension spatiale, et en utilisant le vecteur densité surfacique de courant $`\overrightarrow{j_S}`$.<br>
\- passage de *3D vers 1D*, en négligeant de façon justifiée deux dimensions spatiales, et en utilisant les éléments vectoriels de courant $`I\cdot\overrightarrow{dl}`$.<br>
\- *autre* : ...<br>
Cette étape, indispensable dans le cadre d'un projet, est souvent déjà réalisée dans les énoncés d'exercices ou de problèmes de magnétostatique.

* Le théorème d'Ampère remplace un calcul direct qui serait très complexe, mais il exige pour cela d'obtenir des **informations initiales** *sur le champ magnétique* attendu.<br>
Ces informations **résultent des symétries et invariances** *de la distribution de courant*.<br>
<br>$`\Longrightarrow`$ **ETAPE 2** : *Etude des symétries et invariances.*<br>
<br> C'est une étape *commune aux formes intégrale et locale* du thèorème d'Ampère.

* **ETAPE 3** : *choix de la forme* du théorème d'Ampère et *énoncé mathématique*.

* **ETAPE 4** : 

* **ETAPE 5** : 

##### Déterminer les courants en connaissant $`\overrightarrow{B}`$








